Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_iso_year/index', ['module', 'exports', 'require', '../is_same_iso_year/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isSameISOYear = require('../is_same_iso_year/index');

    /**
     * @category ISO Week-Numbering Year Helpers
     * @summary Is the given date in the same ISO week-numbering year as the current date?
     *
     * @description
     * Is the given date in the same ISO week-numbering year as the current date?
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is in this ISO week-numbering year
     *
     * @example
     * // If today is 25 September 2014,
     * // is 30 December 2013 in this ISO week-numbering year?
     * var result = isThisISOYear(new Date(2013, 11, 30))
     * //=> true
     */
    function isThisISOYear(dirtyDate) {
      return isSameISOYear(new Date(), dirtyDate);
    }

    module.exports = isThisISOYear;
  }
});
//# sourceMappingURL=index.js.map