Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_iso_week/index', ['module', 'exports', 'require', '../is_same_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isSameISOWeek = require('../is_same_iso_week/index');

    /**
     * @category ISO Week Helpers
     * @summary Is the given date in the same ISO week as the current date?
     *
     * @description
     * Is the given date in the same ISO week as the current date?
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is in this ISO week
     *
     * @example
     * // If today is 25 September 2014, is 22 September 2014 in this ISO week?
     * var result = isThisISOWeek(new Date(2014, 8, 22))
     * //=> true
     */
    function isThisISOWeek(dirtyDate) {
      return isSameISOWeek(new Date(), dirtyDate);
    }

    module.exports = isThisISOWeek;
  }
});
//# sourceMappingURL=index.js.map