Liferay.Loader.define('segments-web$date-fns@1.30.1/is_sunday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Weekday Helpers
     * @summary Is the given date Sunday?
     *
     * @description
     * Is the given date Sunday?
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is Sunday
     *
     * @example
     * // Is 21 September 2014 Sunday?
     * var result = isSunday(new Date(2014, 8, 21))
     * //=> true
     */
    function isSunday(dirtyDate) {
      return parse(dirtyDate).getDay() === 0;
    }

    module.exports = isSunday;
  }
});
//# sourceMappingURL=index.js.map