Liferay.Loader.define('segments-web$date-fns@1.30.1/get_seconds/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Second Helpers
     * @summary Get the seconds of the given date.
     *
     * @description
     * Get the seconds of the given date.
     *
     * @param {Date|String|Number} date - the given date
     * @returns {Number} the seconds
     *
     * @example
     * // Get the seconds of 29 February 2012 11:45:05.123:
     * var result = getSeconds(new Date(2012, 1, 29, 11, 45, 5, 123))
     * //=> 5
     */
    function getSeconds(dirtyDate) {
      var date = parse(dirtyDate);
      var seconds = date.getSeconds();
      return seconds;
    }

    module.exports = getSeconds;
  }
});
//# sourceMappingURL=index.js.map