Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_minutes/index', ['module', 'exports', 'require', '../difference_in_milliseconds/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var differenceInMilliseconds = require('../difference_in_milliseconds/index');

    var MILLISECONDS_IN_MINUTE = 60000;

    /**
     * @category Minute Helpers
     * @summary Get the number of minutes between the given dates.
     *
     * @description
     * Get the number of minutes between the given dates.
     *
     * @param {Date|String|Number} dateLeft - the later date
     * @param {Date|String|Number} dateRight - the earlier date
     * @returns {Number} the number of minutes
     *
     * @example
     * // How many minutes are between 2 July 2014 12:07:59 and 2 July 2014 12:20:00?
     * var result = differenceInMinutes(
     *   new Date(2014, 6, 2, 12, 20, 0),
     *   new Date(2014, 6, 2, 12, 7, 59)
     * )
     * //=> 12
     */
    function differenceInMinutes(dirtyDateLeft, dirtyDateRight) {
      var diff = differenceInMilliseconds(dirtyDateLeft, dirtyDateRight) / MILLISECONDS_IN_MINUTE;
      return diff > 0 ? Math.floor(diff) : Math.ceil(diff);
    }

    module.exports = differenceInMinutes;
  }
});
//# sourceMappingURL=index.js.map