Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_calendar_quarters/index', ['module', 'exports', 'require', '../get_quarter/index', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var getQuarter = require('../get_quarter/index');
    var parse = require('../parse/index');

    /**
     * @category Quarter Helpers
     * @summary Get the number of calendar quarters between the given dates.
     *
     * @description
     * Get the number of calendar quarters between the given dates.
     *
     * @param {Date|String|Number} dateLeft - the later date
     * @param {Date|String|Number} dateRight - the earlier date
     * @returns {Number} the number of calendar quarters
     *
     * @example
     * // How many calendar quarters are between 31 December 2013 and 2 July 2014?
     * var result = differenceInCalendarQuarters(
     *   new Date(2014, 6, 2),
     *   new Date(2013, 11, 31)
     * )
     * //=> 3
     */
    function differenceInCalendarQuarters(dirtyDateLeft, dirtyDateRight) {
      var dateLeft = parse(dirtyDateLeft);
      var dateRight = parse(dirtyDateRight);

      var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
      var quarterDiff = getQuarter(dateLeft) - getQuarter(dateRight);

      return yearDiff * 4 + quarterDiff;
    }

    module.exports = differenceInCalendarQuarters;
  }
});
//# sourceMappingURL=index.js.map