Liferay.Loader.define('segments-web$date-fns@1.30.1/add_minutes/index', ['module', 'exports', 'require', '../add_milliseconds/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var addMilliseconds = require('../add_milliseconds/index');

    var MILLISECONDS_IN_MINUTE = 60000;

    /**
     * @category Minute Helpers
     * @summary Add the specified number of minutes to the given date.
     *
     * @description
     * Add the specified number of minutes to the given date.
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} amount - the amount of minutes to be added
     * @returns {Date} the new date with the minutes added
     *
     * @example
     * // Add 30 minutes to 10 July 2014 12:00:00:
     * var result = addMinutes(new Date(2014, 6, 10, 12, 0), 30)
     * //=> Thu Jul 10 2014 12:30:00
     */
    function addMinutes(dirtyDate, dirtyAmount) {
      var amount = Number(dirtyAmount);
      return addMilliseconds(dirtyDate, amount * MILLISECONDS_IN_MINUTE);
    }

    module.exports = addMinutes;
  }
});
//# sourceMappingURL=index.js.map