Liferay.Loader.define('segments-web$date-fns@1.30.1/add_days/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Day Helpers
     * @summary Add the specified number of days to the given date.
     *
     * @description
     * Add the specified number of days to the given date.
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} amount - the amount of days to be added
     * @returns {Date} the new date with the days added
     *
     * @example
     * // Add 10 days to 1 September 2014:
     * var result = addDays(new Date(2014, 8, 1), 10)
     * //=> Thu Sep 11 2014 00:00:00
     */
    function addDays(dirtyDate, dirtyAmount) {
      var date = parse(dirtyDate);
      var amount = Number(dirtyAmount);
      date.setDate(date.getDate() + amount);
      return date;
    }

    module.exports = addDays;
  }
});
//# sourceMappingURL=index.js.map