Liferay.Loader.define("segments-web@2.0.22/js/utils/types.es", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.propertyShape = exports.propertyGroupShape = exports.operatorShape = exports.contributorShape = exports.criterionShape = exports.initialContributorShape = exports.criteriaShape = exports.conjunctionShape = exports.propertyTypesShape = void 0;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * A Property is a reference to define behaviour of each
     * criterion in the Criteria Editor.
     *
     */
    var propertyShape = _propTypes["default"].shape({
      entityUrl: _propTypes["default"].string,
      label: _propTypes["default"].string,
      name: _propTypes["default"].string.isRequired,
      options: _propTypes["default"].array,
      type: _propTypes["default"].string.isRequired
    });

    exports.propertyShape = propertyShape;

    var conjunctionShape = _propTypes["default"].shape({
      label: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    });
    /**
     * A Criterion is the unit that forms a rule.
     *
     * {propertyName} works as an identifier to related to a property
     */

    exports.conjunctionShape = conjunctionShape;

    var criterionShape = _propTypes["default"].shape({
      displayValue: _propTypes["default"].string,
      operatorName: _propTypes["default"].string,
      propertyName: _propTypes["default"].string,
      value: _propTypes["default"].oneOfType([_propTypes["default"].array, _propTypes["default"].number, _propTypes["default"].string])
    });
    /**
     * A Criteria is contains and defines the relationship of a set of Criterion.
     * Those Criterion can be contained as well in a Criteria.
     */

    exports.criterionShape = criterionShape;

    var criteriaShape = _propTypes["default"].shape({
      conjunctionName: _propTypes["default"].string,
      groupId: _propTypes["default"].string
    });

    exports.criteriaShape = criteriaShape;
    criteriaShape.items = _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([criteriaShape, criterionShape]));
    /**
     * The Initial Contributor is a way to define the Contributor
     * that the server provides at the app initialization
     * to the app. The front has to parse it.
     *
     * - conjunctionId: the value of the congunction
     * - conjunctionInputId: an identifier for the back-fornt relationship
     * - initialQuery: the Criteria in a oData query format
     * - inputId: an identifier for the back-fornt relationship
     * - propertyKey: an indentifier to help get information about the properties in its Property Group
     */

    var initialContributorShape = _propTypes["default"].shape({
      conjunctionId: _propTypes["default"].string.isRequired,
      conjunctionInputId: _propTypes["default"].string.isRequired,
      initialQuery: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].shape(null)]),
      inputId: _propTypes["default"].string.isRequired,
      propertyKey: _propTypes["default"].string.isRequired
    });
    /**
     * A Contributor contains a set Criterias, Properties and identifiers.
     *
     * - conjunctionId: the value of the congunction
     * - conjunctionInputId: an identifier for the back-fornt relationship
     * - criteriaMap: a Criteria frontend consumable
     * - entityName: an identifier for the back-front relationship
     * - inputId: an identifier for the back-fornt relationship
     * - modelLabel: a human friendly name of the type of Contributor
     * - properties: a list of properties that can conform the Criteria of this Contributor
     * - propertyKey: an indentifier to help get information about the properties in its Property Group
     * - query: the Criteria in oData query format
     */

    exports.initialContributorShape = initialContributorShape;

    var contributorShape = _propTypes["default"].shape({
      conjunctionId: _propTypes["default"].string,
      conjunctionInputId: _propTypes["default"].string,
      criteriaMap: _propTypes["default"].oneOfType([criteriaShape, _propTypes["default"].shape(null)]),
      entityName: _propTypes["default"].string,
      inputId: _propTypes["default"].string,
      modelLabel: _propTypes["default"].string,
      properties: _propTypes["default"].arrayOf(propertyShape),
      propertyKey: _propTypes["default"].string,
      query: _propTypes["default"].string
    });
    /**
     * An Operator defines the relationship between a property and a value in a Criterion
     * - label: human friendly value
     * - name: computer frinedly value
     */

    exports.contributorShape = contributorShape;

    var operatorShape = _propTypes["default"].shape({
      label: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    });
    /**
     * A Property Group contains a set of Properties that can be used
     * to create a Criteria in a Contributor
     */

    exports.operatorShape = operatorShape;

    var propertyGroupShape = _propTypes["default"].shape({
      entityName: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired,
      properties: _propTypes["default"].arrayOf(propertyShape).isRequired,
      propertyKey: _propTypes["default"].string.isRequired
    });
    /**
     * The Property Types contains a relationship of the types of properties
     * and their compatible operators
     */

    exports.propertyGroupShape = propertyGroupShape;

    var propertyTypesShape = _propTypes["default"].shape({
      "boolean": _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired,
      date: _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired,
      "double": _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired,
      id: _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired,
      integer: _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired,
      string: _propTypes["default"].arrayOf(_propTypes["default"].string).isRequired
    });

    exports.propertyTypesShape = propertyTypesShape;
    //# sourceMappingURL=types.es.js.map
  }
});
//# sourceMappingURL=types.es.js.map