Liferay.Loader.define("segments-web@2.0.22/js/utils/contributors.es", ['module', 'exports', 'require', './constants.es', './odata.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.initialContributorsToContributors = initialContributorsToContributors;
    exports.applyCriteriaChangeToContributors = applyCriteriaChangeToContributors;
    exports.applyConjunctionChangeToContributor = applyConjunctionChangeToContributor;

    var _constants = require("./constants.es");

    var _odata = require("./odata.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Produces a list of Contributors
     * from a list of initialContributors
     * and a list of propertyGroups
     *
     * @export
     * @param {Object[]} initialContributors
     * @param {string} initialContributors[].conjunctionId
     * @param {string} initialContributors[].conjunctionInputId
     * @param {Object} initialContributors[].criteriaMap
     * @param {string} initialContributors[].entityName
     * @param {string} initialContributors[].inputId
     * @param {string} initialContributors[].modelLabel
     * @param {Array} initialContributors[].properties
     * @param {string} initialContributors[].propertyKey
     * @param {string} initialContributors[].query
     *
     * @param {Object[]} propertyGroups
     * @param {string} propertyGroups[].entityName
     * @param {string} propertyGroups[].name
     * @param {Array} propertyGroups[].properties
     * @param {string} propertyGroups[].propertyKey
     *
     * @typedef {{
     *   conjunctionId: string,
     *   conjunctionInputId: string,
     *   criteriaMap: Object,
     *   entityName: string,
     *   inputId: string,
     *   modelLabel: string,
     *   properties: Array,
     *   propertyKey: string,
     *   query: string
     * }} Contributor
     *
     * @return {Contributor[]} contributors
     */
    function initialContributorsToContributors(initialContributors, propertyGroups) {
      var DEFAULT_CONTRIBUTOR = {
        conjunctionId: _constants.CONJUNCTIONS.AND
      };

      var _ref = initialContributors.find(function (c) {
        return c.conjunctionId;
      }) || DEFAULT_CONTRIBUTOR,
          initialConjunction = _ref.conjunctionId;

      return initialContributors.map(function (initialContributor) {
        var propertyGroup = propertyGroups && propertyGroups.find(function (propertyGroup) {
          return initialContributor.propertyKey === propertyGroup.propertyKey;
        });
        return {
          conjunctionId: initialContributor.conjunctionId || initialConjunction,
          conjunctionInputId: initialContributor.conjunctionInputId,
          criteriaMap: initialContributor.initialQuery ? (0, _odata.translateQueryToCriteria)(initialContributor.initialQuery) : null,
          entityName: propertyGroup && propertyGroup.entityName,
          inputId: initialContributor.inputId,
          modelLabel: propertyGroup && propertyGroup.name,
          properties: propertyGroup && propertyGroup.properties,
          propertyKey: initialContributor.propertyKey,
          query: initialContributor.initialQuery
        };
      });
    }
    /**
     * Applies a criteria change to a contributor from a list
     * in both the criteriaMap and query properties
     *
     * @export
     * @param {Contributor[]} contributors
     * @param {{ propertyKey: string, criteriaChange: Array }} change - Contains the criteria change and an identifier to locate the right contributor
     *
     * @return {Contributor[]} contributors
     */

    function applyCriteriaChangeToContributors(contributors, change) {
      return contributors.map(function (contributor) {
        var conjunctionId = contributor.conjunctionId,
            properties = contributor.properties,
            propertyKey = contributor.propertyKey;
        return change.propertyKey === propertyKey ? _objectSpread({}, contributor, {
          criteriaMap: change.criteriaChange,
          query: (0, _odata.buildQueryString)([change.criteriaChange], conjunctionId, properties)
        }) : contributor;
      });
    }
    /**
     * Applies a conjunction change to the whole array of contributors
     *
     * @export
     * @param {Contributor[]} contributors
     * @return {Contributor[]} contributors
     */

    function applyConjunctionChangeToContributor(contributors, conjunctionName) {
      var conjunctionIndex = _constants.SUPPORTED_CONJUNCTIONS.findIndex(function (item) {
        return item.name === conjunctionName;
      });

      if (conjunctionIndex === -1) {
        return contributors;
      }

      var nextContributors = contributors.map(function (contributor) {
        return _objectSpread({}, contributor, {
          conjunctionId: conjunctionName
        });
      });
      return nextContributors;
    }
    //# sourceMappingURL=contributors.es.js.map
  }
});
//# sourceMappingURL=contributors.es.js.map