Liferay.Loader.define("segments-web@2.0.22/js/components/title_editor/LocalizedDropdown.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../utils/key-constants.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _keyConstants = require("../../utils/key-constants.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var LocalizedDropdown = /*#__PURE__*/function (_React$Component) {
      _inherits(LocalizedDropdown, _React$Component);

      function LocalizedDropdown(props) {
        var _this;

        _classCallCheck(this, LocalizedDropdown);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(LocalizedDropdown).call(this, props));

        _defineProperty(_assertThisInitialized(_this), "_handleButtonClick", function () {
          _this.setState(function (prevState) {
            return {
              open: !prevState.open
            };
          });
        });

        _defineProperty(_assertThisInitialized(_this), "_handleButtonBlur", function () {
          if (_this.state.open) {
            _this.timer = setTimeout(function () {
              _this.setState(function () {
                return {
                  open: false
                };
              });
            }, 200);
          }
        });

        _defineProperty(_assertThisInitialized(_this), "_changeLanguage", function (langKey) {
          _this.setState({
            currentLangKey: keyLangToLanguageTag(langKey),
            currentLangTag: keyLangToLanguageTag(langKey, false),
            open: false
          }, function () {
            return _this.props.onLanguageChange(langKey);
          });
        });

        _defineProperty(_assertThisInitialized(_this), "_handleItemFocus", function () {
          clearTimeout(_this.timer);
        });

        _defineProperty(_assertThisInitialized(_this), "_handleLanguageClick", function (langKey) {
          return function () {
            return _this._changeLanguage(langKey);
          };
        });

        _defineProperty(_assertThisInitialized(_this), "_handleLanguageKeyboard", function (langKey) {
          return function (e) {
            if (e.keyCode === _keyConstants.ENTER) {
              _this._changeLanguage(langKey);
            }
          };
        });

        var initialLang = props.initialLang,
            initialOpen = props.initialOpen;
        _this.state = {
          currentLangKey: keyLangToLanguageTag(initialLang),
          currentLangTag: keyLangToLanguageTag(initialLang, false),
          open: initialOpen
        };
        return _this;
      }

      _createClass(LocalizedDropdown, [{
        key: "render",
        value: function render() {
          var _this2 = this;

          var _this$state = this.state,
              currentLangKey = _this$state.currentLangKey,
              currentLangTag = _this$state.currentLangTag,
              open = _this$state.open;
          var _this$props = this.props,
              availableLanguages = _this$props.availableLanguages,
              defaultLang = _this$props.defaultLang;
          return _react["default"].createElement("div", {
            className: "dropdown postion-relative lfr-icon-menu ".concat(open ? 'open' : '')
          }, _react["default"].createElement("button", {
            "aria-expanded": "false",
            "aria-haspopup": "true",
            className: "btn btn-monospaced btn-secondary dropdown-toggle",
            "data-testid": "localized-dropdown-button",
            onBlur: this._handleButtonBlur,
            onClick: this._handleButtonClick,
            role: "button",
            title: "",
            type: "button"
          }, _react["default"].createElement("span", {
            className: "inline-item"
          }, _react["default"].createElement(_icon["default"], {
            key: currentLangKey,
            symbol: currentLangKey
          })), _react["default"].createElement("span", {
            className: "btn-section"
          }, currentLangTag)), open && _react["default"].createElement("ul", {
            className: "d-block dropdown-menu",
            role: "menu"
          }, availableLanguages.map(function (entry) {
            var hasValue = entry.hasValue,
                key = entry.key;
            return _react["default"].createElement("li", {
              key: key,
              onBlur: _this2._handleButtonBlur,
              onClick: _this2._handleLanguageClick(key),
              onFocus: _this2._handleItemFocus,
              onKeyDown: _this2._handleLanguageKeyboard(key),
              role: "presentation"
            }, _react["default"].createElement("span", {
              className: "dropdown-item lfr-icon-item palette-item taglib-icon",
              role: "menuitem",
              tabIndex: "0",
              target: "_self"
            }, _react["default"].createElement("span", {
              className: "inline-item inline-item-before"
            }, _react["default"].createElement(_icon["default"], {
              symbol: keyLangToLanguageTag(key)
            })), _react["default"].createElement("span", {
              className: "taglib-text-icon"
            }, keyLangToLanguageTag(key, false), defaultLang === key && _react["default"].createElement("span", {
              className: "label label-info ml-1"
            }, Liferay.Language.get('default-value')), defaultLang !== key && (hasValue ? _react["default"].createElement("span", {
              className: "label label-success ml-1"
            }, Liferay.Language.get('translated')) : _react["default"].createElement("span", {
              className: "label label-warning ml-1"
            }, Liferay.Language.get('untranslated'))))));
          })));
        }
      }]);

      return LocalizedDropdown;
    }(_react["default"].Component);
    /**
     * Helper to deal with the differnce in language keys for
     * human reading, svg consumption and keys
     *
     * @param {string} [keyLang='']
     * @param {boolean} [lowercase=true]
     * @returns {string}
     */

    _defineProperty(LocalizedDropdown, "defaultProps", {
      availableLanguages: []
    });

    function keyLangToLanguageTag() {
      var keyLang = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var lowercase = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var langTag = keyLang.replace(/_/g, '-');

      if (lowercase) {
        langTag = langTag.toLowerCase();
      }

      return langTag;
    }

    var _default = LocalizedDropdown;
    exports["default"] = _default;
    //# sourceMappingURL=LocalizedDropdown.es.js.map
  }
});
//# sourceMappingURL=LocalizedDropdown.es.js.map