Liferay.Loader.define("segments-web@2.0.22/js/components/criteria_sidebar/CriteriaSidebarCollapse.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/badge', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'segments-web$date-fns', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../utils/constants.es', '../../utils/types.es', '../../utils/utils.es', './CriteriaSidebarItem.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _badge = _interopRequireDefault(require("@frontend-taglib-clay$clayui/badge"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dateFns = _interopRequireDefault(require("segments-web$date-fns"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _constants = require("../../utils/constants.es");

    var _types = require("../../utils/types.es");

    var _utils = require("../../utils/utils.es");

    var _CriteriaSidebarItem = _interopRequireDefault(require("./CriteriaSidebarItem.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var INPUT_DATE_FORMAT = 'YYYY-MM-DD';
    /**
     * Returns a default value for a property provided.
     * @param {Object} property
     * @returns {string}
     */

    function getDefaultValue(property) {
      var options = property.options,
          type = property.type;
      var defaultValue = '';

      if (type === _constants.PROPERTY_TYPES.STRING && options && options.length) {
        defaultValue = options[0].value;
      } else if (type === _constants.PROPERTY_TYPES.DATE) {
        defaultValue = (0, _utils.jsDatetoYYYYMMDD)(new Date());
      } else if (type === _constants.PROPERTY_TYPES.DATE_TIME) {
        var simpleDate = (0, _utils.jsDatetoYYYYMMDD)(new Date());
        defaultValue = _dateFns["default"].parse(simpleDate, INPUT_DATE_FORMAT).toISOString();
      } else if (type === _constants.PROPERTY_TYPES.BOOLEAN) {
        defaultValue = 'true';
      } else if (type === _constants.PROPERTY_TYPES.INTEGER && options && options.length) {
        defaultValue = options[0].value;
      } else if (type === _constants.PROPERTY_TYPES.INTEGER) {
        defaultValue = 0;
      } else if (type === _constants.PROPERTY_TYPES.DOUBLE && options && options.length) {
        defaultValue = options[0].value;
      } else if (type === _constants.PROPERTY_TYPES.DOUBLE) {
        defaultValue = '0.00';
      }

      return defaultValue;
    }
    /**
     * Filters properties by label
     */

    function filterProperties(properties, searchValue) {
      return properties.filter(function (property) {
        var propertyLabel = property.label.toLowerCase();
        return propertyLabel.indexOf(searchValue.toLowerCase()) !== -1;
      });
    }

    var CriteriaSidebarCollapse = function CriteriaSidebarCollapse(_ref) {
      var onCollapseClick = _ref.onCollapseClick,
          propertyGroups = _ref.propertyGroups,
          propertyKey = _ref.propertyKey,
          searchValue = _ref.searchValue;

      var _handleClick = function _handleClick(key, editing) {
        return function () {
          return onCollapseClick(key, editing);
        };
      };

      return _react["default"].createElement("ul", {
        className: "list-unstyled sidebar-collapse-groups"
      }, propertyGroups.map(function (propertyGroup) {
        var key = propertyGroup.propertyKey;
        var active = key === propertyKey;
        var properties = propertyGroup ? propertyGroup.properties : [];
        var filteredProperties = searchValue ? filterProperties(properties, searchValue) : properties;
        var activeClasses = (0, _classnames["default"])({
          active: active
        });
        var propertyListClasses = (0, _classnames["default"])('properties-list', activeClasses);
        return _react["default"].createElement("li", {
          className: "sidebar-collapse-".concat(propertyGroup.propertyKey),
          key: key
        }, _react["default"].createElement("div", {
          className: "sidebar-collapse-header-root",
          onClick: _handleClick(key, active)
        }, _react["default"].createElement("a", {
          className: "d-flex justify-content-between sidebar-collapse-header"
        }, propertyGroup.name, searchValue && _react["default"].createElement(_badge["default"], {
          className: "ml-auto mr-2",
          displayType: "secondary",
          label: filteredProperties.length
        }), _react["default"].createElement("span", {
          className: "collapse-icon"
        }, _react["default"].createElement(_icon["default"], {
          className: activeClasses,
          symbol: "angle-right"
        })))), _react["default"].createElement("ul", {
          className: propertyListClasses
        }, active && filteredProperties.length === 0 && _react["default"].createElement("li", {
          className: "empty-message"
        }, Liferay.Language.get('no-results-were-found')), active && filteredProperties.length > 0 && filteredProperties.map(function (_ref2) {
          var label = _ref2.label,
              name = _ref2.name,
              options = _ref2.options,
              type = _ref2.type;
          var defaultValue = getDefaultValue({
            label: label,
            name: name,
            options: options,
            type: type
          });
          return _react["default"].createElement(_CriteriaSidebarItem["default"], {
            className: "color--".concat(key),
            defaultValue: defaultValue,
            key: name,
            label: label,
            name: name,
            propertyKey: key,
            type: type
          });
        })));
      }));
    };

    var _default = CriteriaSidebarCollapse;
    exports["default"] = _default;
    //# sourceMappingURL=CriteriaSidebarCollapse.es.js.map
  }
});
//# sourceMappingURL=CriteriaSidebarCollapse.es.js.map