Liferay.Loader.define("segments-web@2.0.22/js/components/criteria_builder/ContributorsBuilder.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', '../../utils/types.es', '../../utils/utils.es', '../criteria_sidebar/CriteriaSidebar.es', './Conjunction.es', './CriteriaBuilder.es', './EmptyPlaceholder.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _reactDnd = require("frontend-js-react-web$react-dnd");

    var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

    var _types = require("../../utils/types.es");

    var _utils = require("../../utils/utils.es");

    var _CriteriaSidebar = _interopRequireDefault(require("../criteria_sidebar/CriteriaSidebar.es"));

    var _Conjunction = _interopRequireDefault(require("./Conjunction.es"));

    var _CriteriaBuilder = _interopRequireDefault(require("./CriteriaBuilder.es"));

    var _EmptyPlaceholder = _interopRequireDefault(require("./EmptyPlaceholder.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var ContributorBuilder = /*#__PURE__*/function (_React$Component) {
      _inherits(ContributorBuilder, _React$Component);

      function ContributorBuilder(props) {
        var _this;

        _classCallCheck(this, ContributorBuilder);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ContributorBuilder).call(this, props));

        _defineProperty(_assertThisInitialized(_this), "_handleCriteriaChange", function (criteriaChange, index) {
          var onQueryChange = _this.props.onQueryChange;
          onQueryChange(criteriaChange, index);
        });

        _defineProperty(_assertThisInitialized(_this), "_handleCriteriaEdit", function (id, editing) {
          _this.setState({
            editingId: editing ? undefined : id
          });
        });

        var contributors = props.contributors,
            propertyGroups = props.propertyGroups;
        var firstContributorNotEmpty = contributors.find(function (contributor) {
          return contributor.query !== '';
        });
        var propertyKey = firstContributorNotEmpty ? firstContributorNotEmpty.propertyKey : propertyGroups[0].propertyKey;
        _this.state = {
          editingId: propertyKey
        };
        return _this;
      }

      _createClass(ContributorBuilder, [{
        key: "render",
        value: function render() {
          var _this2 = this;

          var _this$props = this.props,
              contributors = _this$props.contributors,
              editing = _this$props.editing,
              emptyContributors = _this$props.emptyContributors,
              membersCount = _this$props.membersCount,
              membersCountLoading = _this$props.membersCountLoading,
              onConjunctionChange = _this$props.onConjunctionChange,
              onPreviewMembers = _this$props.onPreviewMembers,
              propertyGroups = _this$props.propertyGroups,
              supportedConjunctions = _this$props.supportedConjunctions,
              supportedOperators = _this$props.supportedOperators,
              supportedPropertyTypes = _this$props.supportedPropertyTypes;
          var editingId = this.state.editingId;
          var rootClasses = (0, _classnames["default"])('contributor-builder-root', {
            editing: editing
          });
          return _react["default"].createElement(_reactDnd.DndProvider, {
            backend: _reactDndHtml5Backend.HTML5Backend
          }, _react["default"].createElement("div", {
            className: rootClasses
          }, _react["default"].createElement("div", {
            className: "criteria-builder-section-sidebar"
          }, _react["default"].createElement(_CriteriaSidebar["default"], {
            onTitleClicked: this._handleCriteriaEdit,
            propertyGroups: propertyGroups,
            propertyKey: editingId
          })), _react["default"].createElement("div", {
            className: "criteria-builder-section-main"
          }, _react["default"].createElement("div", {
            className: "contributor-container"
          }, _react["default"].createElement(_layout["default"].ContainerFluid, null, _react["default"].createElement("div", {
            className: "content-wrapper"
          }, _react["default"].createElement(_layout["default"].Sheet, null, _react["default"].createElement("div", {
            className: "d-flex flex-wrap justify-content-between mb-4"
          }, _react["default"].createElement("h2", {
            className: "mb-2 sheet-title"
          }, Liferay.Language.get('conditions')), _react["default"].createElement("div", {
            className: "criterion-string"
          }, _react["default"].createElement("div", {
            className: "btn-group"
          }, _react["default"].createElement("div", {
            className: "btn-group-item inline-item"
          }, membersCountLoading && _react["default"].createElement(_loadingIndicator["default"], {
            className: "mr-4",
            small: true
          }), !membersCountLoading && _react["default"].createElement("span", {
            className: "mr-4"
          }, Liferay.Language.get('conditions-match'), _react["default"].createElement("b", {
            className: "ml-2 text-dark"
          }, (0, _utils.getPluralMessage)(Liferay.Language.get('x-member'), Liferay.Language.get('x-members'), membersCount))), _react["default"].createElement(_button["default"], {
            displayType: "secondary",
            onClick: onPreviewMembers,
            small: true,
            type: "button"
          }, Liferay.Language.get('view-members')))))), emptyContributors && (editingId === undefined || !editing) && _react["default"].createElement(_EmptyPlaceholder["default"], null), contributors.filter(function (criteria) {
            var editingCriteria = editingId === criteria.propertyKey && editing;
            var emptyCriteriaQuery = criteria.query === '';
            return editingCriteria || !emptyCriteriaQuery;
          }).map(function (criteria, i) {
            return _react["default"].createElement(_react["default"].Fragment, {
              key: i
            }, i !== 0 && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_Conjunction["default"], {
              className: "mb-4 ml-0 mt-4",
              conjunctionName: criteria.conjunctionId,
              editing: editing,
              onSelect: onConjunctionChange,
              supportedConjunctions: supportedConjunctions
            })), _react["default"].createElement(_CriteriaBuilder["default"], {
              criteria: criteria.criteriaMap,
              editing: editing,
              emptyContributors: emptyContributors,
              entityName: criteria.entityName,
              modelLabel: criteria.modelLabel,
              onChange: _this2._handleCriteriaChange,
              propertyKey: criteria.propertyKey,
              supportedConjunctions: supportedConjunctions,
              supportedOperators: supportedOperators,
              supportedProperties: criteria.properties,
              supportedPropertyTypes: supportedPropertyTypes
            }));
          }))))))));
        }
      }]);

      return ContributorBuilder;
    }(_react["default"].Component);

    _defineProperty(ContributorBuilder, "defaultProps", {
      contributors: [],
      membersCount: 0,
      membersCountLoading: false,
      onConjunctionChange: function onConjunctionChange() {},
      onPreviewMembers: function onPreviewMembers() {},
      onQueryChange: function onQueryChange() {}
    });

    var _default = ContributorBuilder;
    exports["default"] = _default;
    //# sourceMappingURL=ContributorsBuilder.es.js.map
  }
});
//# sourceMappingURL=ContributorsBuilder.es.js.map