"use strict";

Liferay.Loader.define("segments-web$odata-v4-parser@0.1.29/lib/utils", ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    Object.defineProperty(exports, "__esModule", { value: true });
    var Utils;
    (function (Utils) {
        Utils.stringify = function stringify(value, index, next) {
            return Array.prototype.map.call(value.slice(index, next), function (ch) {
                return String.fromCharCode(ch);
            }).join("");
        };

        Utils.is = function is(value, compare) {
            for (var i = 0; i < compare.length; i++) {
                if (value === compare.charCodeAt(i)) return true;
            }
            return false;
        };

        Utils.equals = function equals(value, index, compare) {
            var i = 0;
            while (value[index + i] === compare.charCodeAt(i) && i < compare.length) {
                i++;
            }
            return i === compare.length ? i : 0;
        };

        Utils.required = function required(value, index, comparer, min, max) {
            var i = 0;
            max = max || value.length - index;
            while (i < max && comparer(value[index + i])) {
                i++;
            }
            return i >= (min || 0) && i <= max ? index + i : 0;
        };
    })(Utils = exports.Utils || (exports.Utils = {}));
    exports.default = Utils;
    //# sourceMappingURL=utils.js.map
});
//# sourceMappingURL=utils.js.map