Liferay.Loader.define('segments-web$lodash@4.17.15/toPlainObject', ['module', 'exports', 'require', './_copyObject', './keysIn'], function (module, exports, require) {
  var define = undefined;
  var copyObject = require('./_copyObject'),
      keysIn = require('./keysIn');

  /**
   * Converts `value` to a plain object flattening inherited enumerable string
   * keyed properties of `value` to own properties of the plain object.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Lang
   * @param {*} value The value to convert.
   * @returns {Object} Returns the converted plain object.
   * @example
   *
   * function Foo() {
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.assign({ 'a': 1 }, new Foo);
   * // => { 'a': 1, 'b': 2 }
   *
   * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
   * // => { 'a': 1, 'b': 2, 'c': 3 }
   */
  function toPlainObject(value) {
    return copyObject(value, keysIn(value));
  }

  module.exports = toPlainObject;
});
//# sourceMappingURL=toPlainObject.js.map