Liferay.Loader.define('segments-web$lodash@4.17.15/sortedUniq', ['module', 'exports', 'require', './_baseSortedUniq'], function (module, exports, require) {
  var define = undefined;
  var baseSortedUniq = require('./_baseSortedUniq');

  /**
   * This method is like `_.uniq` except that it's designed and optimized
   * for sorted arrays.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @returns {Array} Returns the new duplicate free array.
   * @example
   *
   * _.sortedUniq([1, 1, 2]);
   * // => [1, 2]
   */
  function sortedUniq(array) {
    return array && array.length ? baseSortedUniq(array) : [];
  }

  module.exports = sortedUniq;
});
//# sourceMappingURL=sortedUniq.js.map