Liferay.Loader.define('segments-web$lodash@4.17.15/snakeCase', ['module', 'exports', 'require', './_createCompounder'], function (module, exports, require) {
  var define = undefined;
  var createCompounder = require('./_createCompounder');

  /**
   * Converts `string` to
   * [snake case](https://en.wikipedia.org/wiki/Snake_case).
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the snake cased string.
   * @example
   *
   * _.snakeCase('Foo Bar');
   * // => 'foo_bar'
   *
   * _.snakeCase('fooBar');
   * // => 'foo_bar'
   *
   * _.snakeCase('--FOO-BAR--');
   * // => 'foo_bar'
   */
  var snakeCase = createCompounder(function (result, word, index) {
    return result + (index ? '_' : '') + word.toLowerCase();
  });

  module.exports = snakeCase;
});
//# sourceMappingURL=snakeCase.js.map