Liferay.Loader.define('segments-web$lodash@4.17.15/sample', ['module', 'exports', 'require', './_arraySample', './_baseSample', './isArray'], function (module, exports, require) {
  var define = undefined;
  var arraySample = require('./_arraySample'),
      baseSample = require('./_baseSample'),
      isArray = require('./isArray');

  /**
   * Gets a random element from `collection`.
   *
   * @static
   * @memberOf _
   * @since 2.0.0
   * @category Collection
   * @param {Array|Object} collection The collection to sample.
   * @returns {*} Returns the random element.
   * @example
   *
   * _.sample([1, 2, 3, 4]);
   * // => 2
   */
  function sample(collection) {
    var func = isArray(collection) ? arraySample : baseSample;
    return func(collection);
  }

  module.exports = sample;
});
//# sourceMappingURL=sample.js.map