Liferay.Loader.define('segments-web$lodash@4.17.15/minBy', ['module', 'exports', 'require', './_baseExtremum', './_baseIteratee', './_baseLt'], function (module, exports, require) {
    var define = undefined;
    var baseExtremum = require('./_baseExtremum'),
        baseIteratee = require('./_baseIteratee'),
        baseLt = require('./_baseLt');

    /**
     * This method is like `_.min` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the criterion by which
     * the value is ranked. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {*} Returns the minimum value.
     * @example
     *
     * var objects = [{ 'n': 1 }, { 'n': 2 }];
     *
     * _.minBy(objects, function(o) { return o.n; });
     * // => { 'n': 1 }
     *
     * // The `_.property` iteratee shorthand.
     * _.minBy(objects, 'n');
     * // => { 'n': 1 }
     */
    function minBy(array, iteratee) {
        return array && array.length ? baseExtremum(array, baseIteratee(iteratee, 2), baseLt) : undefined;
    }

    module.exports = minBy;
});
//# sourceMappingURL=minBy.js.map