Liferay.Loader.define('segments-web$lodash@4.17.15/flip', ['module', 'exports', 'require', './_createWrap'], function (module, exports, require) {
  var define = undefined;
  var createWrap = require('./_createWrap');

  /** Used to compose bitmasks for function metadata. */
  var WRAP_FLIP_FLAG = 512;

  /**
   * Creates a function that invokes `func` with arguments reversed.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Function
   * @param {Function} func The function to flip arguments for.
   * @returns {Function} Returns the new flipped function.
   * @example
   *
   * var flipped = _.flip(function() {
   *   return _.toArray(arguments);
   * });
   *
   * flipped('a', 'b', 'c', 'd');
   * // => ['d', 'c', 'b', 'a']
   */
  function flip(func) {
    return createWrap(func, WRAP_FLIP_FLAG);
  }

  module.exports = flip;
});
//# sourceMappingURL=flip.js.map