Liferay.Loader.define('segments-web$lodash@4.17.15/flattenDepth', ['module', 'exports', 'require', './_baseFlatten', './toInteger'], function (module, exports, require) {
  var define = undefined;
  var baseFlatten = require('./_baseFlatten'),
      toInteger = require('./toInteger');

  /**
   * Recursively flatten `array` up to `depth` times.
   *
   * @static
   * @memberOf _
   * @since 4.4.0
   * @category Array
   * @param {Array} array The array to flatten.
   * @param {number} [depth=1] The maximum recursion depth.
   * @returns {Array} Returns the new flattened array.
   * @example
   *
   * var array = [1, [2, [3, [4]], 5]];
   *
   * _.flattenDepth(array, 1);
   * // => [1, 2, [3, [4]], 5]
   *
   * _.flattenDepth(array, 2);
   * // => [1, 2, 3, [4], 5]
   */
  function flattenDepth(array, depth) {
    var length = array == null ? 0 : array.length;
    if (!length) {
      return [];
    }
    depth = depth === undefined ? 1 : toInteger(depth);
    return baseFlatten(array, depth);
  }

  module.exports = flattenDepth;
});
//# sourceMappingURL=flattenDepth.js.map