Liferay.Loader.define('segments-web$lodash@4.17.15/_isFlattenable', ['module', 'exports', 'require', './_Symbol', './isArguments', './isArray'], function (module, exports, require) {
    var define = undefined;
    var Symbol = require('./_Symbol'),
        isArguments = require('./isArguments'),
        isArray = require('./isArray');

    /** Built-in value references. */
    var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;

    /**
     * Checks if `value` is a flattenable `arguments` object or array.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
     */
    function isFlattenable(value) {
        return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
    }

    module.exports = isFlattenable;
});
//# sourceMappingURL=_isFlattenable.js.map