Liferay.Loader.define("segments-web$lodash@4.17.15/_hasUnicodeWord", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /** Used to detect strings that need a more robust regexp to match words. */
  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

  /**
   * Checks if `string` contains a word composed of Unicode symbols.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {boolean} Returns `true` if a word is found, else `false`.
   */
  function hasUnicodeWord(string) {
    return reHasUnicodeWord.test(string);
  }

  module.exports = hasUnicodeWord;
});
//# sourceMappingURL=_hasUnicodeWord.js.map