Liferay.Loader.define('segments-web$lodash@4.17.15/_getFuncName', ['module', 'exports', 'require', './_realNames'], function (module, exports, require) {
  var define = undefined;
  var realNames = require('./_realNames');

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /** Used to check objects for own properties. */
  var hasOwnProperty = objectProto.hasOwnProperty;

  /**
   * Gets the name of `func`.
   *
   * @private
   * @param {Function} func The function to query.
   * @returns {string} Returns the function name.
   */
  function getFuncName(func) {
    var result = func.name + '',
        array = realNames[result],
        length = hasOwnProperty.call(realNames, result) ? array.length : 0;

    while (length--) {
      var data = array[length],
          otherFunc = data.func;
      if (otherFunc == null || otherFunc == func) {
        return data.name;
      }
    }
    return result;
  }

  module.exports = getFuncName;
});
//# sourceMappingURL=_getFuncName.js.map