Liferay.Loader.define('segments-web$lodash@4.17.15/_createOver', ['module', 'exports', 'require', './_apply', './_arrayMap', './_baseIteratee', './_baseRest', './_baseUnary', './_flatRest'], function (module, exports, require) {
  var define = undefined;
  var apply = require('./_apply'),
      arrayMap = require('./_arrayMap'),
      baseIteratee = require('./_baseIteratee'),
      baseRest = require('./_baseRest'),
      baseUnary = require('./_baseUnary'),
      flatRest = require('./_flatRest');

  /**
   * Creates a function like `_.over`.
   *
   * @private
   * @param {Function} arrayFunc The function to iterate over iteratees.
   * @returns {Function} Returns the new over function.
   */
  function createOver(arrayFunc) {
    return flatRest(function (iteratees) {
      iteratees = arrayMap(iteratees, baseUnary(baseIteratee));
      return baseRest(function (args) {
        var thisArg = this;
        return arrayFunc(iteratees, function (iteratee) {
          return apply(iteratee, thisArg, args);
        });
      });
    });
  }

  module.exports = createOver;
});
//# sourceMappingURL=_createOver.js.map