/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

'use strict';

Liferay.Loader.define('segments-web$fbjs@0.8.17/lib/forEachObject', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var hasOwnProperty = Object.prototype.hasOwnProperty;

  /**
   * Executes the provided `callback` once for each enumerable own property in the
   * object. The `callback` is invoked with three arguments:
   *
   *  - the property value
   *  - the property name
   *  - the object being traversed
   *
   * Properties that are added after the call to `forEachObject` will not be
   * visited by `callback`. If the values of existing properties are changed, the
   * value passed to `callback` will be the value at the time `forEachObject`
   * visits them. Properties that are deleted before being visited are not
   * visited.
   *
   * @param {?object} object
   * @param {function} callback
   * @param {*} context
   */
  function forEachObject(object, callback, context) {
    for (var name in object) {
      if (hasOwnProperty.call(object, name)) {
        callback.call(context, object[name], name, object);
      }
    }
  }

  module.exports = forEachObject;
});
//# sourceMappingURL=forEachObject.js.map