Liferay.Loader.define('segments-web$dnd-core@7.7.0/lib/esm/actions/dragDrop/endDrag', ['module', 'exports', 'require', 'segments-web$invariant'], function (module, exports, require) {
    var define = undefined;
    import { END_DRAG } from './types';
    const invariant = require('segments-web$invariant');
    export default function createEndDrag(manager) {
        return function endDrag() {
            const monitor = manager.getMonitor();
            const registry = manager.getRegistry();
            verifyIsDragging(monitor);
            const sourceId = monitor.getSourceId();
            const source = registry.getSource(sourceId, true);
            source.endDrag(monitor, sourceId);
            registry.unpinSource();
            return { type: END_DRAG };
        };
    }
    function verifyIsDragging(monitor) {
        invariant(monitor.isDragging(), 'Cannot call endDrag while not dragging.');
    }
});
//# sourceMappingURL=endDrag.js.map