"use strict";

Liferay.Loader.define("segments-web$dnd-core@7.7.0/lib/cjs/reducers/index", ['module', 'exports', 'require', './dragOffset', './dragOperation', './refCount', './dirtyHandlerIds', './stateId', '../utils/discount_lodash'], function (module, exports, require) {
    var define = undefined;
    var __assign = this && this.__assign || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var dragOffset_1 = require("./dragOffset");
    var dragOperation_1 = require("./dragOperation");
    var refCount_1 = require("./refCount");
    var dirtyHandlerIds_1 = require("./dirtyHandlerIds");
    var stateId_1 = require("./stateId");
    var discount_lodash_1 = require("../utils/discount_lodash");
    function reduce(state, action) {
        if (state === void 0) {
            state = {};
        }
        return {
            dirtyHandlerIds: dirtyHandlerIds_1.default(state.dirtyHandlerIds, {
                type: action.type,
                payload: __assign({}, action.payload, { prevTargetIds: discount_lodash_1.get(state, 'dragOperation.targetIds', []) })
            }),
            dragOffset: dragOffset_1.default(state.dragOffset, action),
            refCount: refCount_1.default(state.refCount, action),
            dragOperation: dragOperation_1.default(state.dragOperation, action),
            stateId: stateId_1.default(state.stateId)
        };
    }
    exports.default = reduce;
});
//# sourceMappingURL=index.js.map