"use strict";

Liferay.Loader.define("segments-web$dnd-core@7.7.0/lib/cjs/reducers/dragOffset", ['module', 'exports', 'require', '../actions/dragDrop', '../utils/equality'], function (module, exports, require) {
    var define = undefined;
    var __assign = this && this.__assign || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var dragDrop_1 = require("../actions/dragDrop");
    var equality_1 = require("../utils/equality");
    var initialState = {
        initialSourceClientOffset: null,
        initialClientOffset: null,
        clientOffset: null
    };
    function dragOffset(state, action) {
        if (state === void 0) {
            state = initialState;
        }
        var payload = action.payload;
        switch (action.type) {
            case dragDrop_1.INIT_COORDS:
            case dragDrop_1.BEGIN_DRAG:
                return {
                    initialSourceClientOffset: payload.sourceClientOffset,
                    initialClientOffset: payload.clientOffset,
                    clientOffset: payload.clientOffset
                };
            case dragDrop_1.HOVER:
                if (equality_1.areCoordsEqual(state.clientOffset, payload.clientOffset)) {
                    return state;
                }
                return __assign({}, state, { clientOffset: payload.clientOffset });
            case dragDrop_1.END_DRAG:
            case dragDrop_1.DROP:
                return initialState;
            default:
                return state;
        }
    }
    exports.default = dragOffset;
});
//# sourceMappingURL=dragOffset.js.map