Liferay.Loader.define('segments-web$date-fns@1.30.1/sub_milliseconds/index', ['module', 'exports', 'require', '../add_milliseconds/index'], function (module, exports, require) {
  var define = undefined;
  var addMilliseconds = require('../add_milliseconds/index');

  /**
   * @category Millisecond Helpers
   * @summary Subtract the specified number of milliseconds from the given date.
   *
   * @description
   * Subtract the specified number of milliseconds from the given date.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} amount - the amount of milliseconds to be subtracted
   * @returns {Date} the new date with the milliseconds subtracted
   *
   * @example
   * // Subtract 750 milliseconds from 10 July 2014 12:45:30.000:
   * var result = subMilliseconds(new Date(2014, 6, 10, 12, 45, 30, 0), 750)
   * //=> Thu Jul 10 2014 12:45:29.250
   */
  function subMilliseconds(dirtyDate, dirtyAmount) {
    var amount = Number(dirtyAmount);
    return addMilliseconds(dirtyDate, -amount);
  }

  module.exports = subMilliseconds;
});
//# sourceMappingURL=index.js.map