Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_minute/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Minute Helpers
   * @summary Return the start of a minute for the given date.
   *
   * @description
   * Return the start of a minute for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the start of a minute
   *
   * @example
   * // The start of a minute for 1 December 2014 22:15:45.400:
   * var result = startOfMinute(new Date(2014, 11, 1, 22, 15, 45, 400))
   * //=> Mon Dec 01 2014 22:15:00
   */
  function startOfMinute(dirtyDate) {
    var date = parse(dirtyDate);
    date.setSeconds(0, 0);
    return date;
  }

  module.exports = startOfMinute;
});
//# sourceMappingURL=index.js.map