Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_iso_year/index', ['module', 'exports', 'require', '../get_iso_year/index', '../start_of_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var getISOYear = require('../get_iso_year/index');
  var startOfISOWeek = require('../start_of_iso_week/index');

  /**
   * @category ISO Week-Numbering Year Helpers
   * @summary Return the start of an ISO week-numbering year for the given date.
   *
   * @description
   * Return the start of an ISO week-numbering year,
   * which always starts 3 days before the year's first Thursday.
   * The result will be in the local timezone.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the start of an ISO year
   *
   * @example
   * // The start of an ISO week-numbering year for 2 July 2005:
   * var result = startOfISOYear(new Date(2005, 6, 2))
   * //=> Mon Jan 03 2005 00:00:00
   */
  function startOfISOYear(dirtyDate) {
    var year = getISOYear(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setFullYear(year, 0, 4);
    fourthOfJanuary.setHours(0, 0, 0, 0);
    var date = startOfISOWeek(fourthOfJanuary);
    return date;
  }

  module.exports = startOfISOYear;
});
//# sourceMappingURL=index.js.map