Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_iso_week/index', ['module', 'exports', 'require', '../start_of_week/index'], function (module, exports, require) {
  var define = undefined;
  var startOfWeek = require('../start_of_week/index');

  /**
   * @category ISO Week Helpers
   * @summary Return the start of an ISO week for the given date.
   *
   * @description
   * Return the start of an ISO week for the given date.
   * The result will be in the local timezone.
   *
   * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the start of an ISO week
   *
   * @example
   * // The start of an ISO week for 2 September 2014 11:55:00:
   * var result = startOfISOWeek(new Date(2014, 8, 2, 11, 55, 0))
   * //=> Mon Sep 01 2014 00:00:00
   */
  function startOfISOWeek(dirtyDate) {
    return startOfWeek(dirtyDate, { weekStartsOn: 1 });
  }

  module.exports = startOfISOWeek;
});
//# sourceMappingURL=index.js.map