Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_hour/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Hour Helpers
   * @summary Return the start of an hour for the given date.
   *
   * @description
   * Return the start of an hour for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the start of an hour
   *
   * @example
   * // The start of an hour for 2 September 2014 11:55:00:
   * var result = startOfHour(new Date(2014, 8, 2, 11, 55))
   * //=> Tue Sep 02 2014 11:00:00
   */
  function startOfHour(dirtyDate) {
    var date = parse(dirtyDate);
    date.setMinutes(0, 0, 0);
    return date;
  }

  module.exports = startOfHour;
});
//# sourceMappingURL=index.js.map