Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_day/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Day Helpers
   * @summary Return the start of a day for the given date.
   *
   * @description
   * Return the start of a day for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the start of a day
   *
   * @example
   * // The start of a day for 2 September 2014 11:55:00:
   * var result = startOfDay(new Date(2014, 8, 2, 11, 55, 0))
   * //=> Tue Sep 02 2014 00:00:00
   */
  function startOfDay(dirtyDate) {
    var date = parse(dirtyDate);
    date.setHours(0, 0, 0, 0);
    return date;
  }

  module.exports = startOfDay;
});
//# sourceMappingURL=index.js.map