Liferay.Loader.define('segments-web$date-fns@1.30.1/set_quarter/index', ['module', 'exports', 'require', '../parse/index', '../set_month/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var setMonth = require('../set_month/index');

  /**
   * @category Quarter Helpers
   * @summary Set the year quarter to the given date.
   *
   * @description
   * Set the year quarter to the given date.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} quarter - the quarter of the new date
   * @returns {Date} the new date with the quarter setted
   *
   * @example
   * // Set the 2nd quarter to 2 July 2014:
   * var result = setQuarter(new Date(2014, 6, 2), 2)
   * //=> Wed Apr 02 2014 00:00:00
   */
  function setQuarter(dirtyDate, dirtyQuarter) {
    var date = parse(dirtyDate);
    var quarter = Number(dirtyQuarter);
    var oldQuarter = Math.floor(date.getMonth() / 3) + 1;

    return setMonth(date, date.getMonth() + (quarter - oldQuarter) * 3);
  }

  module.exports = setQuarter;
});
//# sourceMappingURL=index.js.map