Liferay.Loader.define('segments-web$date-fns@1.30.1/set_month/index', ['module', 'exports', 'require', '../parse/index', '../get_days_in_month/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var getDaysInMonth = require('../get_days_in_month/index');

  /**
   * @category Month Helpers
   * @summary Set the month to the given date.
   *
   * @description
   * Set the month to the given date.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} month - the month of the new date
   * @returns {Date} the new date with the month setted
   *
   * @example
   * // Set February to 1 September 2014:
   * var result = setMonth(new Date(2014, 8, 1), 1)
   * //=> Sat Feb 01 2014 00:00:00
   */
  function setMonth(dirtyDate, dirtyMonth) {
    var date = parse(dirtyDate);
    var month = Number(dirtyMonth);
    var year = date.getFullYear();
    var day = date.getDate();

    var dateWithDesiredMonth = new Date(0);
    dateWithDesiredMonth.setFullYear(year, month, 15);
    dateWithDesiredMonth.setHours(0, 0, 0, 0);
    var daysInMonth = getDaysInMonth(dateWithDesiredMonth);
    // Set the last day of the new month
    // if the original date was the last day of the longer month
    date.setMonth(month, Math.min(day, daysInMonth));
    return date;
  }

  module.exports = setMonth;
});
//# sourceMappingURL=index.js.map