Liferay.Loader.define('segments-web$date-fns@1.30.1/set_iso_day/index', ['module', 'exports', 'require', '../parse/index', '../add_days/index', '../get_iso_day/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');
  var addDays = require('../add_days/index');
  var getISODay = require('../get_iso_day/index');

  /**
   * @category Weekday Helpers
   * @summary Set the day of the ISO week to the given date.
   *
   * @description
   * Set the day of the ISO week to the given date.
   * ISO week starts with Monday.
   * 7 is the index of Sunday, 1 is the index of Monday etc.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} day - the day of the ISO week of the new date
   * @returns {Date} the new date with the day of the ISO week setted
   *
   * @example
   * // Set Sunday to 1 September 2014:
   * var result = setISODay(new Date(2014, 8, 1), 7)
   * //=> Sun Sep 07 2014 00:00:00
   */
  function setISODay(dirtyDate, dirtyDay) {
    var date = parse(dirtyDate);
    var day = Number(dirtyDay);
    var currentDay = getISODay(date);

    return addDays(date, day - currentDay);
  }

  module.exports = setISODay;
});
//# sourceMappingURL=index.js.map