Liferay.Loader.define('segments-web$date-fns@1.30.1/set_day_of_year/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Day Helpers
   * @summary Set the day of the year to the given date.
   *
   * @description
   * Set the day of the year to the given date.
   *
   * @param {Date|String|Number} date - the date to be changed
   * @param {Number} dayOfYear - the day of the year of the new date
   * @returns {Date} the new date with the day of the year setted
   *
   * @example
   * // Set the 2nd day of the year to 2 July 2014:
   * var result = setDayOfYear(new Date(2014, 6, 2), 2)
   * //=> Thu Jan 02 2014 00:00:00
   */
  function setDayOfYear(dirtyDate, dirtyDayOfYear) {
    var date = parse(dirtyDate);
    var dayOfYear = Number(dirtyDayOfYear);
    date.setMonth(0);
    date.setDate(dayOfYear);
    return date;
  }

  module.exports = setDayOfYear;
});
//# sourceMappingURL=index.js.map