Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/zh_cn/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

  function buildFormatLocale() {
    var months3char = ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'];
    var monthsFull = ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'];
    var weekdays2char = ['日', '一', '二', '三', '四', '五', '六'];
    var weekdays3char = ['周日', '周一', '周二', '周三', '周四', '周五', '周六'];
    var weekdaysFull = ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'];
    var meridiemFull = ['上午', '下午'];

    var formatters = {
      // Month: Jan, Feb, ..., Dec
      'MMM': function (date) {
        return months3char[date.getMonth()];
      },

      // Month: January, February, ..., December
      'MMMM': function (date) {
        return monthsFull[date.getMonth()];
      },

      // Day of week: Su, Mo, ..., Sa
      'dd': function (date) {
        return weekdays2char[date.getDay()];
      },

      // Day of week: Sun, Mon, ..., Sat
      'ddd': function (date) {
        return weekdays3char[date.getDay()];
      },

      // Day of week: Sunday, Monday, ..., Saturday
      'dddd': function (date) {
        return weekdaysFull[date.getDay()];
      }

      // AM, PM / am, pm / a.m., p.m. all translates to 上午, 下午
    };formatters.a = formatters.aa = formatters.A = function (date) {
      return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
    };

    // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.

    ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
      formatters[formatterToken + 'o'] = function (date, formatters) {
        return ordinal(formatters[formatterToken](date));
      };
    });

    return {
      formatters: formatters,
      formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
    };
  }

  function ordinal(number) {
    return number.toString();
  }

  module.exports = buildFormatLocale;
});
//# sourceMappingURL=index.js.map