Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/mk/build_distance_in_words_locale/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function buildDistanceInWordsLocale() {
    var distanceInWordsLocale = {
      lessThanXSeconds: {
        one: 'помалку од секунда',
        other: 'помалку од {{count}} секунди'
      },

      xSeconds: {
        one: '1 секунда',
        other: '{{count}} секунди'
      },

      halfAMinute: 'половина минута',

      lessThanXMinutes: {
        one: 'помалку од минута',
        other: 'помалку од {{count}} минути'
      },

      xMinutes: {
        one: '1 минута',
        other: '{{count}} минути'
      },

      aboutXHours: {
        one: 'околу 1 час',
        other: 'околу {{count}} часа'
      },

      xHours: {
        one: '1 час',
        other: '{{count}} часа'
      },

      xDays: {
        one: '1 ден',
        other: '{{count}} дена'
      },

      aboutXMonths: {
        one: 'околу 1 месец',
        other: 'околу {{count}} месеци'
      },

      xMonths: {
        one: '1 месец',
        other: '{{count}} месеци'
      },

      aboutXYears: {
        one: 'околу 1 година',
        other: 'околу {{count}} години'
      },

      xYears: {
        one: '1 година',
        other: '{{count}} години'
      },

      overXYears: {
        one: 'повеќе од 1 година',
        other: 'повеќе од {{count}} години'
      },

      almostXYears: {
        one: 'безмалку 1 година',
        other: 'безмалку {{count}} години'
      }
    };

    return {
      localize: function localize(token, count, options) {
        options = options || {};

        var result;
        if (typeof distanceInWordsLocale[token] === 'string') {
          result = distanceInWordsLocale[token];
        } else if (count === 1) {
          result = distanceInWordsLocale[token].one;
        } else {
          result = distanceInWordsLocale[token].other.replace('{{count}}', count);
        }

        if (options.addSuffix) {
          if (options.comparison > 0) {
            return 'за ' + result;
          } else {
            return 'пред ' + result;
          }
        }

        return result;
      }
    };
  }

  module.exports = buildDistanceInWordsLocale;
});
//# sourceMappingURL=index.js.map