Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/ja/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

  function buildFormatLocale() {
    var months3char = ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'];
    var monthsFull = ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'];
    var weekdays2char = ['日', '月', '火', '水', '木', '金', '土'];
    var weekdays3char = ['日曜', '月曜', '火曜', '水曜', '木曜', '金曜', '土曜'];
    var weekdaysFull = ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'];
    var meridiemUppercase = ['午前', '午後'];
    var meridiemLowercase = ['午前', '午後'];
    var meridiemFull = ['午前', '午後'];

    var formatters = {
      // Month: Jan, Feb, ..., Dec
      'MMM': function (date) {
        return months3char[date.getMonth()];
      },

      // Month: January, February, ..., December
      'MMMM': function (date) {
        return monthsFull[date.getMonth()];
      },

      // Day of week: Su, Mo, ..., Sa
      'dd': function (date) {
        return weekdays2char[date.getDay()];
      },

      // Day of week: Sun, Mon, ..., Sat
      'ddd': function (date) {
        return weekdays3char[date.getDay()];
      },

      // Day of week: Sunday, Monday, ..., Saturday
      'dddd': function (date) {
        return weekdaysFull[date.getDay()];
      },

      // AM, PM
      'A': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemUppercase[1] : meridiemUppercase[0];
      },

      // am, pm
      'a': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemLowercase[1] : meridiemLowercase[0];
      },

      // a.m., p.m.
      'aa': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
      }

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.
    };
    ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
      formatters[formatterToken + 'o'] = function (date, formatters) {
        return ordinal(formatters[formatterToken](date));
      };
    });

    return {
      formatters: formatters,
      formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
    };
  }

  function ordinal(number) {
    return number + '日';
  }

  module.exports = buildFormatLocale;
});
//# sourceMappingURL=index.js.map