Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/id/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

  function buildFormatLocale() {
    // Note: in Indonesian, the names of days of the week and months are capitalized.
    // If you are making a new locale based on this one, check if the same is true for the language you're working on.
    // Generally, formatted dates should look like they are in the middle of a sentence,
    // e.g. in Spanish language the weekdays and months should be in the lowercase.
    var months3char = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
    var monthsFull = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
    var weekdays2char = ['Mi', 'Sn', 'Sl', 'Ra', 'Ka', 'Ju', 'Sa'];
    var weekdays3char = ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'];
    var weekdaysFull = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
    var meridiemUppercase = ['AM', 'PM'];
    var meridiemLowercase = ['am', 'pm'];
    var meridiemFull = ['a.m.', 'p.m.'];

    var formatters = {
      // Month: Jan, Feb, ..., Dec
      'MMM': function (date) {
        return months3char[date.getMonth()];
      },

      // Month: January, February, ..., December
      'MMMM': function (date) {
        return monthsFull[date.getMonth()];
      },

      // Day of week: Su, Mo, ..., Sa
      'dd': function (date) {
        return weekdays2char[date.getDay()];
      },

      // Day of week: Sun, Mon, ..., Sat
      'ddd': function (date) {
        return weekdays3char[date.getDay()];
      },

      // Day of week: Sunday, Monday, ..., Saturday
      'dddd': function (date) {
        return weekdaysFull[date.getDay()];
      },

      // AM, PM
      'A': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemUppercase[1] : meridiemUppercase[0];
      },

      // am, pm
      'a': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemLowercase[1] : meridiemLowercase[0];
      },

      // a.m., p.m.
      'aa': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
      }

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.
    };
    ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
      formatters[formatterToken + 'o'] = function (date, formatters) {
        return ordinal(formatters[formatterToken](date));
      };
    });

    return {
      formatters: formatters,
      formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
    };
  }

  function ordinal(number) {
    switch (number) {
      case 1:
        return 'pertama';
      case 2:
        return 'kedua';
      case 3:
        return 'ketiga';
      default:
        return 'ke-' + number;
    }
  }

  module.exports = buildFormatLocale;
});
//# sourceMappingURL=index.js.map