Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/hr/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

  function buildFormatLocale() {
    var months3char = ['sij', 'velj', 'ožu', 'tra', 'svi', 'lip', 'srp', 'kol', 'ruj', 'lis', 'stu', 'pro'];
    var monthsFull = ['siječanj', 'veljača', 'ožujak', 'travanj', 'svibanj', 'lipanj', 'srpanj', 'kolovoz', 'rujan', 'listopad', 'studeni', 'prosinac'];
    var monthsGenitive = ['siječnja', 'veljače', 'ožujka', 'travnja', 'svibnja', 'lipnja', 'srpnja', 'kolovoza', 'rujna', 'listopada', 'studenog', 'prosinca'];
    var weekdays2char = ['ne', 'po', 'ut', 'sr', 'če', 'pe', 'su'];
    var weekdays3char = ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'];
    var weekdaysFull = ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda', 'četvrtak', 'petak', 'subota'];
    var meridiemUppercase = ['ujutro', 'popodne'];
    var meridiemLowercase = ['ujutro', 'popodne'];
    var meridiemFull = ['ujutro', 'popodne'];

    var formatters = {
      // Month: Jan, Feb, ..., Dec
      'MMM': function (date) {
        return months3char[date.getMonth()];
      },

      // Month: January, February, ..., December
      'MMMM': function (date) {
        return monthsFull[date.getMonth()];
      },

      // Day of week: Su, Mo, ..., Sa
      'dd': function (date) {
        return weekdays2char[date.getDay()];
      },

      // Day of week: Sun, Mon, ..., Sat
      'ddd': function (date) {
        return weekdays3char[date.getDay()];
      },

      // Day of week: Sunday, Monday, ..., Saturday
      'dddd': function (date) {
        return weekdaysFull[date.getDay()];
      },

      // AM, PM
      'A': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemUppercase[1] : meridiemUppercase[0];
      },

      // am, pm
      'a': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemLowercase[1] : meridiemLowercase[0];
      },

      // a.m., p.m.
      'aa': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
      }

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.
    };
    ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
      formatters[formatterToken + 'o'] = function (date, formatters) {
        return ordinal(formatters[formatterToken](date));
      };
    });

    // Generate formatters like 'D MMMM', where the month is in the genitive case

    ['D', 'Do', 'DD'].forEach(function (formatterToken) {
      formatters[formatterToken + ' MMM'] = function (date, commonFormatters) {
        var formatter = formatters[formatterToken] || commonFormatters[formatterToken];
        return formatter(date, commonFormatters) + ' ' + monthsGenitive[date.getMonth()];
      };
    });

    return {
      formatters: formatters,
      formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
    };
  }

  function ordinal(number) {
    return number + '.';
  }

  module.exports = buildFormatLocale;
});
//# sourceMappingURL=index.js.map