Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/da/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

  function buildFormatLocale() {
    var months3char = ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'dec'];
    var monthsFull = ['januar', 'februar', 'marts', 'april', 'maj', 'juni', 'juli', 'august', 'september', 'oktober', 'november', 'december'];
    var weekdays2char = ['sø', 'ma', 'ti', 'on', 'to', 'fr', 'lø'];
    var weekdays3char = ['søn', 'man', 'tir', 'ons', 'tor', 'fre', 'lør'];
    var weekdaysFull = ['søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag', 'lørdag'];
    var meridiemUppercase = ['AM', 'PM'];
    var meridiemLowercase = ['am', 'pm'];
    var meridiemFull = ['a.m.', 'p.m.'];

    var formatters = {
      // Month: Jan, Feb, ..., Dec
      'MMM': function (date) {
        return months3char[date.getMonth()];
      },

      // Month: January, February, ..., December
      'MMMM': function (date) {
        return monthsFull[date.getMonth()];
      },

      // Day of week: Su, Mo, ..., Sa
      'dd': function (date) {
        return weekdays2char[date.getDay()];
      },

      // Day of week: Sun, Mon, ..., Sat
      'ddd': function (date) {
        return weekdays3char[date.getDay()];
      },

      // Day of week: Sunday, Monday, ..., Saturday
      'dddd': function (date) {
        return weekdaysFull[date.getDay()];
      },

      // AM, PM
      'A': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemUppercase[1] : meridiemUppercase[0];
      },

      // am, pm
      'a': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemLowercase[1] : meridiemLowercase[0];
      },

      // a.m., p.m.
      'aa': function (date) {
        return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
      }

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.
    };
    ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
      formatters[formatterToken + 'o'] = function (date, formatters) {
        return ordinal(formatters[formatterToken](date));
      };
    });

    return {
      formatters: formatters,
      formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
    };
  }

  function ordinal(number) {
    return number + '.';
  }

  module.exports = buildFormatLocale;
});
//# sourceMappingURL=index.js.map