Liferay.Loader.define('segments-web$date-fns@1.30.1/last_day_of_year/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Year Helpers
   * @summary Return the last day of a year for the given date.
   *
   * @description
   * Return the last day of a year for the given date.
   * The result will be in the local timezone.
   *
   * @param {Date|String|Number} date - the original date
   * @returns {Date} the last day of a year
   *
   * @example
   * // The last day of a year for 2 September 2014 11:55:00:
   * var result = lastDayOfYear(new Date(2014, 8, 2, 11, 55, 00))
   * //=> Wed Dec 31 2014 00:00:00
   */
  function lastDayOfYear(dirtyDate) {
    var date = parse(dirtyDate);
    var year = date.getFullYear();
    date.setFullYear(year + 1, 0, 0);
    date.setHours(0, 0, 0, 0);
    return date;
  }

  module.exports = lastDayOfYear;
});
//# sourceMappingURL=index.js.map