Liferay.Loader.define('segments-web$date-fns@1.30.1/is_yesterday/index', ['module', 'exports', 'require', '../start_of_day/index'], function (module, exports, require) {
  var define = undefined;
  var startOfDay = require('../start_of_day/index');

  /**
   * @category Day Helpers
   * @summary Is the given date yesterday?
   *
   * @description
   * Is the given date yesterday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is yesterday
   *
   * @example
   * // If today is 6 October 2014, is 5 October 14:00:00 yesterday?
   * var result = isYesterday(new Date(2014, 9, 5, 14, 0))
   * //=> true
   */
  function isYesterday(dirtyDate) {
    var yesterday = new Date();
    yesterday.setDate(yesterday.getDate() - 1);
    return startOfDay(dirtyDate).getTime() === startOfDay(yesterday).getTime();
  }

  module.exports = isYesterday;
});
//# sourceMappingURL=index.js.map