Liferay.Loader.define('segments-web$date-fns@1.30.1/is_wednesday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Weekday Helpers
   * @summary Is the given date Wednesday?
   *
   * @description
   * Is the given date Wednesday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is Wednesday
   *
   * @example
   * // Is 24 September 2014 Wednesday?
   * var result = isWednesday(new Date(2014, 8, 24))
   * //=> true
   */
  function isWednesday(dirtyDate) {
    return parse(dirtyDate).getDay() === 3;
  }

  module.exports = isWednesday;
});
//# sourceMappingURL=index.js.map