Liferay.Loader.define('segments-web$date-fns@1.30.1/is_valid/index', ['module', 'exports', 'require', '../is_date/index'], function (module, exports, require) {
  var define = undefined;
  var isDate = require('../is_date/index');

  /**
   * @category Common Helpers
   * @summary Is the given date valid?
   *
   * @description
   * Returns false if argument is Invalid Date and true otherwise.
   * Invalid Date is a Date, whose time value is NaN.
   *
   * Time value of Date: http://es5.github.io/#x15.9.1.1
   *
   * @param {Date} date - the date to check
   * @returns {Boolean} the date is valid
   * @throws {TypeError} argument must be an instance of Date
   *
   * @example
   * // For the valid date:
   * var result = isValid(new Date(2014, 1, 31))
   * //=> true
   *
   * @example
   * // For the invalid date:
   * var result = isValid(new Date(''))
   * //=> false
   */
  function isValid(dirtyDate) {
    if (isDate(dirtyDate)) {
      return !isNaN(dirtyDate);
    } else {
      throw new TypeError(toString.call(dirtyDate) + ' is not an instance of Date');
    }
  }

  module.exports = isValid;
});
//# sourceMappingURL=index.js.map