Liferay.Loader.define('segments-web$date-fns@1.30.1/is_tuesday/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var parse = require('../parse/index');

  /**
   * @category Weekday Helpers
   * @summary Is the given date Tuesday?
   *
   * @description
   * Is the given date Tuesday?
   *
   * @param {Date|String|Number} date - the date to check
   * @returns {Boolean} the date is Tuesday
   *
   * @example
   * // Is 23 September 2014 Tuesday?
   * var result = isTuesday(new Date(2014, 8, 23))
   * //=> true
   */
  function isTuesday(dirtyDate) {
    return parse(dirtyDate).getDay() === 2;
  }

  module.exports = isTuesday;
});
//# sourceMappingURL=index.js.map